#ifndef LINT
static char SCCSid[] = "@(#)";
#endif


/* 
 Derived from JA_CT_COSY_06 but using a real 60 reading pulse (pw*60/90)
 Derived from JA_CT_COSY_04 but eliminating some phase cycling computation and introducing solving signal suppresion through presaturation and diffusion 
Juan Aguilar. Durham. 11-07-2013.

		
	Paramters:
		sspul :		y - selects magnetization randomization option
		gzlvl1	:	Coherence selection gradient level
		gt1	:	Gradient time
		gstab	:	Recovery delay
		pw	:	90 degree pulse length at tpwr
		d1	:	relaxation delay
*/

#include <standard.h>

static int 	ph1[4] = {0, 2, 0, 2},
		ph2[4] = {0, 0, 0, 0},
		ph3[4] = {0, 2, 0, 2};

pulsesequence()
{
	double	gzlvl1 = getval("gzlvl1"),
	gzlvl2 = getval("gzlvl2"),
	gt1 = getval("gt1"),
	gstab = getval("gstab"),
	gstab2 = getval("gstab2"),
	cti = getval("cti");

	char	sspul[MAXSTR];
	getstr("sspul",sspul);

	settable(t1,4,ph1);
	settable(t2,4,ph2);
	settable(t3,4,ph3);

	getelem(t1,ct,v1);
	getelem(t2,ct,v2);
	getelem(t3,ct,oph);

	initval(2.0*(double)(((int)(d2*getval("sw1")+0.5)%2)),v10);

cti=2.0*(ni*0.5/sw1+gt1*2.0+gstab*2.0+0.0001);

status(A);

 if (satmode[0] == 'y')
        {       	
		obsoffset(satfrq);
                obspower(satpwr);
		
		if ((d1-satdly) > 0.02)
  			delay(d1-satdly-rof1-rof1);

		else 
		delay(0.02-rof1-rof1);
                rgpulse(satdly,zero,rof1,rof1);	
	zgradpulse(gzlvl2,gt1);	/* Short purging field gradient */
		rgpulse(gstab2,zero,rof1,rof1);
		zgradpulse(gzlvl2*-1.0,gt1);	/* Short purging field gradient */
		delay(gstab);
	        }


	

		else 	{delay (d1);}




   status(B);

	obspower(tpwr);
	obsoffset(tof);
	delay(rof1);



	rgpulse(pw, v1, rof1, rof1);
	
	delay(cti*0.5 - d2*0.5+gstab+gt1); 
	
	zgradpulse(gzlvl1,gt1);
	delay(gstab);
	
	rgpulse(pw*2.0, zero, rof1, rof1);

	zgradpulse(gzlvl1,gt1);
	delay(gstab);
	
	delay(cti*0.5 + d2*0.5); 
		
	zgradpulse(gzlvl1*0.3,gt1);
	delay(gstab);
	
	rgpulse(pw*0.666667, v2, rof1, rof2);
	
	zgradpulse(gzlvl1*0.3,gt1);
	
	delay(gstab);

status(C);
}
